#version 450
#include <layout.glsl>
#include "smoke.glsl"

void main() {
	vec2 uv =  gl_FragCoord.xy / resolution.x;
    vec2 sceneUv = vec2(gl_FragCoord.x / resolution.x, gl_FragCoord.y / resolution.y);
    vec3 scene = texture(sampler2D(sceneTexture, sceneSampler), sceneUv).xyz;
    vec3 smoke = smoke(uv);

    vec3 blendedScene = scene * smokeParams.skyBlend;
    vec3 blendedSmoke = smoke * smokeParams.smokeBlend;
    outputColor = vec4(blendedSmoke + blendedScene, 1);
}
